/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp.test;

import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.Command;
import de.hardwarespielerei.cs2udp.Data;
import de.hardwarespielerei.cs2udp.udp.UDPDevice;
import java.io.IOException;

public class RingBufferTest {
    public static final int RECEIVEPORT = 15731;
    public static final int SENDPORT = 15730;
    public static final int PACKETLENGTH = 13;

    public static void main(String[] args) throws IOException, CS2CANException {
        System.out.println("###############################");
        System.out.println("# Ring Buffer Test V1.0.1003  #");
        System.out.println("# (C) 2014 by Gabriel Schmidt #");
        System.out.println("#  @see hardwarespielerei.de  #");
        System.out.println("###############################");
        System.out.println();
        String server = "127.0.0.1";
        int argPos = 0;
        while (argPos < args.length) {
            String arg = args[argPos++];
            try {
                switch (arg) {
                    case "-server": {
                        server = args[argPos++];
                        break;
                    }
                    default: {
                        System.err.println("[WARN]\tUnkown argument \"" + arg + "\"!");
                        break;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("[WARN]\tMissing parameter for option \"" + arg + "\"!");
            }
        }
        try (UDPDevice device = new UDPDevice(server);){
            System.out.println("Connected to UDP device " + server + " using hash 0x" + Integer.toHexString(device.getHash()) + "...");
            int startindex = 1;
            int id = 0;
            boolean goon = true;
            while (goon) {
                System.out.println("Initializing loc ID " + (startindex + id) + "...");
                device.setLocFunction(startindex + id, (byte)0, (byte)1);
                System.out.println("Testing loc IDs:");
                int i = startindex;
                while (goon && i <= startindex + id) {
                    RingBufferTest.sleep(100L);
                    device.queryLocFunction(i, (byte)0);
                    boolean found = false;
                    while (!found) {
                        if (device.hasMessage()) {
                            CS2CANMessage response = device.readMessage();
                            if (response.getCommand() != Command.LOC_FUNCTION.getID() || !response.isResponse() || 6 != response.getData().length) continue;
                            Data data = new Data(response.getData());
                            int responseID = data.getInteger(0);
                            byte responseFunction = data.getByte(4);
                            byte responseValue = data.getByte(5);
                            boolean bl = found = responseID == i && responseFunction == 0;
                            if (!found) continue;
                            goon = responseValue == 1;
                            System.out.print(goon ? "." : "!");
                            continue;
                        }
                        RingBufferTest.sleep(10L);
                    }
                    ++i;
                }
                System.out.println();
                ++id;
                if (goon) continue;
                System.out.println(String.valueOf(id) + " is too much for the processor!");
            }
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

