/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp;

import de.hardwarespielerei.cs2udp.CS2CANMessage;

public class DirectCommand
extends CS2CANMessage {
    private byte priority;
    private byte command;
    private boolean isResponse;
    private short hash;
    private byte length;
    private byte[] data;

    public DirectCommand(byte priority, byte command, boolean isResponse, short hash, byte length, byte[] data) {
        this.priority = priority;
        this.command = command;
        this.isResponse = isResponse;
        this.hash = hash;
        this.length = length;
        this.data = data;
    }

    public DirectCommand(byte priority, byte command, boolean isResponse, short hash, byte[] data) {
        this.priority = priority;
        this.command = command;
        this.isResponse = isResponse;
        this.hash = hash;
        this.length = (byte)data.length;
        this.data = data;
    }

    public DirectCommand(int id, byte[] data) {
        this.priority = (byte)(id >> 25 & 0xF);
        this.command = (byte)(id >> 17 & 0xFF);
        this.isResponse = 65536 == (id & 0x10000);
        this.hash = (short)(id & 0xFFFF);
        this.length = (byte)data.length;
        this.data = data;
    }

    public DirectCommand(int id, byte length, byte[] data) {
        this.priority = (byte)(id >> 25 & 0xF);
        this.command = (byte)(id >> 17 & 0xFF);
        this.isResponse = 65536 == (id & 0x10000);
        this.hash = (short)(id & 0xFFFF);
        this.length = length;
        this.data = data;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public byte getCommand() {
        return this.command;
    }

    @Override
    public boolean isResponse() {
        return this.isResponse;
    }

    @Override
    public short getHash() {
        return this.hash;
    }

    @Override
    public byte getLength() {
        return this.length;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

