/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Command {
    SYSTEM_COMMAND(0),
    LOC_DISCOVERY(1),
    MFX_BIND(2),
    MFX_VERIFY(3),
    LOC_SPEED(4),
    LOC_DIRECTION(5),
    LOC_FUNCTION(6),
    READ_CONFIG(7),
    WRITE_CONFIG(8),
    ACCESSORY_OPERATE(11),
    ACCESSORY_CONFIG(12),
    S88_POLLING(16),
    S88_EVENT(17),
    SX1_EVENT(18),
    PING(24),
    UPDATE_OFFER(25),
    READ_CONFIG_DATA(26),
    BOOTLOADER_CAN(27),
    BOOTLOADER_TRACK(28),
    STATUS_CONFIG(29),
    CONFIG_DATA_QUERY(32),
    CONFIG_DATA_STREAM(33),
    DATA_STREAM(34);

    private byte id;
    private static Map<Byte, Command> idMap;

    static {
        idMap = new HashMap<Byte, Command>();
        for (Command cmd : EnumSet.allOf(Command.class)) {
            idMap.put(new Byte(cmd.getID()), cmd);
        }
    }

    private Command(byte id) {
        this.id = id;
    }

    public byte getID() {
        Command.values();
        return this.id;
    }

    public static Command getByID(byte id) {
        return idMap.get(new Byte(id));
    }
}

