/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp;

import de.hardwarespielerei.cs2udp.Command;

public abstract class CS2CANMessage {
    public abstract byte getPriority();

    public abstract byte getCommand();

    public abstract boolean isResponse();

    public abstract short getHash();

    public abstract byte getLength();

    public abstract byte[] getData();

    public String toString() {
        Command cmd = Command.getByID(this.getCommand());
        StringBuffer res = new StringBuffer(String.valueOf(this.isResponse() ? "Response" : "Command") + "(" + (cmd == null ? "UndocumentedFeature" : cmd.name()) + "(0x" + Integer.toHexString(this.getCommand()) + "), Hash 0x" + Integer.toHexString(this.getHash()));
        int len = this.getData().length;
        if (len > 0) {
            res.append(", Data [0x");
            res.append(Integer.toHexString(this.getData()[0]));
            int i = 1;
            while (i < len) {
                res.append(", 0x" + Integer.toHexString(this.getData()[i]));
                ++i;
            }
        }
        res.append("])");
        return res.toString();
    }
}

