/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2udp;

import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.Command;
import de.hardwarespielerei.cs2udp.Data;
import de.hardwarespielerei.cs2udp.DirectCommand;

public abstract class CS2CANDevice {
    private static final byte PRIORITY = 0;

    public abstract void close() throws CS2CANException;

    public abstract short getHash();

    public abstract boolean hasMessage() throws CS2CANException;

    public abstract CS2CANMessage readMessage() throws CS2CANException;

    public abstract void writeMessage(CS2CANMessage var1) throws CS2CANException;

    protected short createHash() throws CS2CANException {
        short hash = 768;
        return hash;
    }

    public void ping() throws CS2CANException {
        DirectCommand msg = new DirectCommand(0, Command.PING.getID(), false, this.getHash(), new byte[0]);
        this.writeMessage(msg);
    }

    public void queryLocFunction(int locID, byte function) throws CS2CANException {
        Data data = new Data().set(0, locID).set(4, function);
        DirectCommand msg = new DirectCommand(0, Command.LOC_FUNCTION.getID(), false, this.getHash(), 5, data.getData());
        this.writeMessage(msg);
    }

    public void setLocFunction(int locID, byte function, byte value) throws CS2CANException {
        Data data = new Data().set(0, locID).set(4, function).set(5, value);
        DirectCommand msg = new DirectCommand(0, Command.LOC_FUNCTION.getID(), false, this.getHash(), 6, data.getData());
        this.writeMessage(msg);
    }
}

