/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can.tinycan;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import de.hardwarespielerei.can.tinycan.Bitrate;
import de.hardwarespielerei.can.tinycan.Library;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import de.hardwarespielerei.can.tinycan.jna.NativeAccess;
import java.io.IOException;
import java.util.Arrays;

public class TinyCANTest {
    public static void main(String[] args) throws IOException, TinyCANException {
        System.out.println("################################");
        System.out.println("# Tiny-CAN CS2CAN Test         #");
        System.out.println("# (C) 2014 by Gabriel Schmidt  #");
        System.out.println("#  @see hardwarespielerei.de   #");
        System.out.println("################################");
        System.out.println();
        System.out.println("Tiny-CAN   V0.1.1003");
        System.out.println("JNA        V4.1.0");
        System.out.println("JNA NATIVE V4.0.0");
        System.out.println();
        if (Platform.isWindows()) {
            Library.load();
            try {
                MyException.throwOnErrorCode(Library.call().CanInitDriver(null), "Can't init driver!");
                PointerByReference devicesListReference = new PointerByReference();
                int cnt = Library.call().CanExGetDeviceList(devicesListReference, 1);
                if (cnt < 0) {
                    MyException.throwOnErrorCode(cnt, "Can't get device list!");
                } else if (cnt == 0) {
                    throw new NullPointerException("No Tiny-CAN adapter detected!");
                }
                try {
                    Pointer p = devicesListReference.getValue();
                    int offset = 0;
                    byte[] data = p.getByteArray((long)offset, 363);
                    int canIdx = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
                    int hwId = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
                    byte[] dataString = Arrays.copyOfRange(data, offset, offset += 255);
                    String deviceName = new String(dataString).trim();
                    dataString = Arrays.copyOfRange(data, offset, offset += 16);
                    String serialNumber = new String(dataString).trim();
                    dataString = Arrays.copyOfRange(data, offset, offset += 64);
                    String description = new String(dataString).trim();
                    System.out.println("Adapter found: " + description + " # " + serialNumber);
                    MyException.throwOnErrorCode(Library.call().CanDeviceOpen(0, "Snr=" + serialNumber), "Can't open channel to " + description + " # " + serialNumber + "!");
                    try {
                        NativeAccess.CANMsg[] buffer;
                        MyException.throwOnErrorCode(Library.call().CanSetSpeed(0, (short)250), "Can't bitrate to " + (Object)((Object)Bitrate.Bitrate250kbps) + " kbps on " + description + " # " + serialNumber + "!");
                        MyException.throwOnErrorCode(Library.call().CanSetMode(0, (byte)1, (short)4095), "Can't set mode on " + description + " # " + serialNumber + "!");
                        boolean isLightON = false;
                        while (!isLightON) {
                            int cntRxMsgs = Library.call().CanReceiveGetCount(0);
                            if (cntRxMsgs <= 0) continue;
                            buffer = new NativeAccess.CANMsg[cntRxMsgs];
                            cnt = Library.call().CanReceive(0, buffer, cntRxMsgs);
                            if (cnt < 0) {
                                MyException.throwOnErrorCode(cnt, "Can't read message from adapter " + description + " # " + serialNumber + "!");
                            }
                            int i = 0;
                            while (i < cnt) {
                                NativeAccess.CANMsg msg = buffer[i];
                                if (msg.id == 805632 && msg.data[3] == 72 && msg.data[4] == 0 && msg.data[5] == 1) {
                                    isLightON = true;
                                    System.out.println("Light is ON!");
                                }
                                ++i;
                            }
                        }
                        int id = 787200;
                        buffer = new NativeAccess.CANMsg[]{new NativeAccess.CANMsg()};
                        buffer[0].id = id;
                        buffer[0].flags = 134;
                        buffer[0].data[3] = 72;
                        buffer[0].data[4] = 0;
                        buffer[0].data[5] = 0;
                        buffer[0].time.sec = 0;
                        buffer[0].time.usec = 0;
                        cnt = Library.call().CanTransmit(0, buffer, 1);
                        if (cnt < 0) {
                            MyException.throwOnErrorCode(cnt, "Can't write to adapter " + description + " # " + serialNumber + "!");
                        }
                        cnt = Library.call().CanTransmitGetCount(0);
                        MyException.throwOnErrorCode(Library.call().CanTransmitSet(0, (short)0, 0), "Can't transmit buffer to adapter " + description + " # " + serialNumber + "!");
                        System.out.println("Is Light OFF?");
                    }
                    finally {
                        MyException.throwOnErrorCode(Library.call().CanDeviceClose(0), "Can't close channel to " + description + " # " + serialNumber + "!");
                    }
                }
                finally {
                    Library.call().CanExDataFree(devicesListReference);
                }
            }
            finally {
                Library.unload();
            }
            System.out.println("Tiny-CAN test ends.");
        } else {
            System.err.println("Tiny-CAN is not supported on this platform!");
        }
    }

    private static class MyException
    extends TinyCANException {
        private MyException(int returnCode, String message) {
            super(returnCode, message);
        }

        public static void throwOnErrorCode(int rc, String message) throws TinyCANException {
            TinyCANException.throwOnErrorCode(rc, message);
        }
    }
}

