/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can.canusb;

import de.hardwarespielerei.can.canusb.Adapter;
import de.hardwarespielerei.can.canusb.CANMessage;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.canusb.ReceiveCallback;
import de.hardwarespielerei.cs2can.CS2CANGateway;
import de.hardwarespielerei.cs2can.Status;
import de.hardwarespielerei.cs2can.canusb.CANUSBDevice;
import de.hardwarespielerei.cs2can.canusb.CANUSBMessage;
import de.hardwarespielerei.cs2can.gateway.DefaultStatusLogger;
import de.hardwarespielerei.cs2can.gateway.StatusLogger;
import de.hardwarespielerei.cs2udp.CS2CANDevice;
import de.hardwarespielerei.cs2udp.CS2CANException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class CANUSBGateway
extends CS2CANGateway {
    private static final long CANUSBSTATUSTIME = 10000L;
    private ReceiveCallback callback;
    private CANUSBDevice device;
    private de.hardwarespielerei.can.canusb.Status nativeStatus;
    private long nextNativeStatus = System.currentTimeMillis();

    public CANUSBGateway(Adapter canusb, boolean logCANcmd) throws SocketException, UnknownHostException, CANUSBException, CS2CANException {
        this(canusb, new DefaultStatusLogger(), logCANcmd);
    }

    public CANUSBGateway(Adapter canusb, StatusLogger statusLogger, boolean logCANcmd) throws SocketException, UnknownHostException, CANUSBException, CS2CANException {
        super(statusLogger, logCANcmd);
        try {
            this.callback = new CANUSBReceiveCallback(this, this.sendSocket, this.statusLogger);
            this.device = new CANUSBDevice(canusb, this.callback);
            this.listenerThread.start();
        }
        catch (Exception e) {
            super.close();
            throw e;
        }
    }

    @Override
    public Status getStatus() {
        Status res = Status.FATAL;
        try {
            long now = System.currentTimeMillis();
            if (now > this.nextNativeStatus) {
                this.nativeStatus = this.device.getStatus();
                this.nextNativeStatus = now + 10000L;
            }
            res = this.nativeStatus.isOK() ? Status.FINE : Status.RECOVERY;
        }
        catch (CANUSBException cANUSBException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public CS2CANDevice getDevice() {
        return this.device;
    }

    @Override
    public void close() throws CS2CANException {
        try {
            this.listener.stop();
            this.listenerThread.interrupt();
            while (this.listenerThread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                this.device.close();
            }
            finally {
                super.close();
            }
        }
    }

    private static class CANUSBReceiveCallback
    implements ReceiveCallback {
        private CS2CANGateway gateway;
        private DatagramSocket sendSocket;
        private StatusLogger statusLogger;

        private CANUSBReceiveCallback(CS2CANGateway gateway, DatagramSocket sendSocket, StatusLogger statusLogger) {
            this.gateway = gateway;
            this.sendSocket = sendSocket;
            this.statusLogger = statusLogger;
        }

        @Override
        public void callback(CANMessage nativeMessage) {
            CANUSBMessage msg = new CANUSBMessage(nativeMessage);
            byte[] content = new byte[13];
            Arrays.fill(content, (byte)0);
            int id = nativeMessage.getId();
            int i = 0;
            content[i++] = (byte)(id >> 24 & 0xFF);
            content[i++] = (byte)(id >> 16 & 0xFF);
            content[i++] = (byte)(id >> 8 & 0xFF);
            content[i++] = (byte)(id & 0xFF);
            content[i++] = nativeMessage.getLength();
            int j = 0;
            while (j < nativeMessage.getLength()) {
                content[i++] = nativeMessage.getData()[j];
                ++j;
            }
            this.gateway.broadcastToUDP(msg, content);
        }
    }
}

