/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.cs2can.canusb;

import de.hardwarespielerei.can.canusb.AcceptanceCode;
import de.hardwarespielerei.can.canusb.AcceptanceMask;
import de.hardwarespielerei.can.canusb.Adapter;
import de.hardwarespielerei.can.canusb.Bitrate;
import de.hardwarespielerei.can.canusb.CANMessage;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.canusb.Channel;
import de.hardwarespielerei.can.canusb.Flag;
import de.hardwarespielerei.can.canusb.ReceiveCallback;
import de.hardwarespielerei.can.canusb.Status;
import de.hardwarespielerei.cs2can.canusb.CANUSBIOException;
import de.hardwarespielerei.cs2can.canusb.CANUSBMessage;
import de.hardwarespielerei.cs2can.canusb.CANUSBNativeMessage;
import de.hardwarespielerei.cs2udp.CS2CANDevice;
import de.hardwarespielerei.cs2udp.CS2CANException;
import de.hardwarespielerei.cs2udp.CS2CANMessage;
import de.hardwarespielerei.cs2udp.MessageLostException;
import de.hardwarespielerei.cs2udp.NoMessageException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CANUSBDevice
extends CS2CANDevice {
    public static final int RECEIVEPORT = 15731;
    public static final int SENDPORT = 15730;
    public static final int PACKETLENGTH = 13;
    public static final Bitrate BITRATE = Bitrate.Bitrate250kbps;
    private Adapter canusb;
    private Channel channel;
    private ReceiveCallback receiveCallback;
    private List<CS2CANMessage> receiveList;
    private short hash;

    public CANUSBDevice(Adapter canusb) throws CANUSBException, CS2CANException {
        this.canusb = canusb;
        this.receiveList = Collections.synchronizedList(new LinkedList());
        Flag[] flags = new Flag[]{Flag.Timestamp};
        this.channel = canusb.openChannel(BITRATE, AcceptanceCode.AcceptAll, AcceptanceMask.AcceptAll, flags);
        try {
            this.receiveCallback = new ReceiveListReceiveCallback(this.receiveList);
            this.channel.setReceiveCallBack(this.receiveCallback);
            this.hash = this.createHash();
        }
        catch (Exception e) {
            this.channel.close();
            throw e;
        }
    }

    public CANUSBDevice(Adapter canusb, ReceiveCallback receiveCallback) throws CANUSBException, CS2CANException {
        this.canusb = canusb;
        this.receiveList = Collections.synchronizedList(new LinkedList());
        Flag[] flags = new Flag[]{Flag.Timestamp};
        this.channel = canusb.openChannel(BITRATE, AcceptanceCode.AcceptAll, AcceptanceMask.AcceptAll, flags);
        try {
            this.receiveCallback = new ReceiveListReceiveCallback(this.receiveList);
            this.channel.setReceiveCallBack(this.receiveCallback);
            this.hash = this.createHash();
            this.receiveCallback = receiveCallback;
            this.channel.setReceiveCallBack(this.receiveCallback);
        }
        catch (Exception e) {
            this.channel.close();
            throw e;
        }
    }

    @Override
    public short getHash() {
        return this.hash;
    }

    @Override
    public boolean hasMessage() {
        if (this.receiveCallback instanceof ReceiveListReceiveCallback) {
            return !this.receiveList.isEmpty();
        }
        throw new UnsupportedOperationException("Receive callback active - no polling!");
    }

    @Override
    public CS2CANMessage readMessage() throws CS2CANException {
        if (this.receiveCallback instanceof ReceiveListReceiveCallback) {
            try {
                return this.receiveList.remove(0);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoMessageException("No message in receive queue!", e);
            }
        }
        throw new UnsupportedOperationException("Receive callback active - no polling!");
    }

    @Override
    public void writeMessage(CS2CANMessage msg) throws CS2CANException {
        try {
            this.channel.write(msg instanceof CANUSBMessage ? ((CANUSBMessage)msg).getNativeMessage() : new CANUSBNativeMessage(msg));
        }
        catch (CANUSBException e) {
            throw new MessageLostException("Can't write message to CANUSB adapter " + this.canusb.getSerialNumber() + "!", msg, e);
        }
    }

    public Status getStatus() throws CANUSBException {
        return this.channel.getStatus();
    }

    @Override
    public void close() throws CANUSBIOException {
        try {
            try {
                this.channel.setReceiveCallBack(null);
            }
            catch (CANUSBException cANUSBException) {
                try {
                    this.channel.close();
                }
                catch (CANUSBException e) {
                    throw new CANUSBIOException("Can't close channel to adapter " + this.canusb + "!", e);
                }
            }
        }
        finally {
            try {
                this.channel.close();
            }
            catch (CANUSBException e) {
                throw new CANUSBIOException("Can't close channel to adapter " + this.canusb + "!", e);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.canusb.toString()) + " Channel " + this.channel;
    }

    private static class ReceiveListReceiveCallback
    implements ReceiveCallback {
        private List<CS2CANMessage> receiveList;

        private ReceiveListReceiveCallback(List<CS2CANMessage> receiveList) {
            this.receiveList = receiveList;
        }

        @Override
        public void callback(CANMessage msg) {
            this.receiveList.add(new CANUSBMessage(msg));
        }
    }
}

