/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import de.hardwarespielerei.can.tinycan.CANMessage;
import de.hardwarespielerei.can.tinycan.jna.NativeAccess;

public class NativeMessage
implements CANMessage {
    private NativeAccess.CANMsg msg;

    public NativeMessage(int id, boolean isRemoteTransmitionRequest, boolean isExtendedFrameFormat, byte length, byte[] data, int seconds, int useconds) {
        if (data != null && data.length > 8) {
            throw new IllegalArgumentException("Data is more than 8 bytes long!");
        }
        this.msg = new NativeAccess.CANMsg();
        this.msg.id = id;
        this.msg.flags = length & 0xF | (isRemoteTransmitionRequest ? 64 : 0) | (isExtendedFrameFormat ? 128 : 0);
        int i = 0;
        while (i < data.length) {
            this.msg.data[i] = data[i];
            ++i;
        }
        this.msg.time = new NativeAccess.Time();
        this.msg.time.sec = seconds;
        this.msg.time.usec = useconds;
    }

    protected NativeMessage(NativeAccess.CANMsg msg) {
        this.msg = msg;
    }

    protected NativeAccess.CANMsg getNativeMessage() {
        return this.msg;
    }

    @Override
    public int getId() {
        return this.msg.id;
    }

    @Override
    public boolean isTransmitted() {
        return (this.msg.flags & 0x80000) == 524288;
    }

    @Override
    public boolean isReserved() {
        return (this.msg.flags & 0x40000) == 262144;
    }

    @Override
    public boolean isRemoteTransmitionRequest() {
        return (this.msg.flags & 0x20000) == 131072;
    }

    @Override
    public boolean isExtendedFrameFormat() {
        return (this.msg.flags & 0x10000) == 131072;
    }

    @Override
    public byte getSource() {
        return 0;
    }

    @Override
    public byte getLength() {
        return (byte)(this.msg.flags & 0xF);
    }

    @Override
    public byte[] getData() {
        return this.msg.data;
    }

    @Override
    public int getSeconds() {
        return this.msg.time.sec;
    }

    @Override
    public int getMicroSeconds() {
        return this.msg.time.usec;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ID:          0x").append(NativeMessage.toHexString(this.getId())).append("\t").append(NativeMessage.toBinaryString(this.getId())).append("\n");
        result.append("Length:      ").append(this.getLength()).append("\t0x").append(NativeMessage.toHexString(this.getLength())).append("\n");
        String dataPrefix = "Data:\t";
        byte[] byArray = this.getData();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte data = byArray[n2];
            result.append(dataPrefix).append(data).append("\t0x").append(NativeMessage.toHexString(data)).append("\t").append(NativeMessage.toBinaryString(data)).append("\n");
            dataPrefix = "\t";
            ++n2;
        }
        return result.toString();
    }

    private static String toHexString(int value, int len) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() > len) {
            hexString = hexString.substring(hexString.length() - len, hexString.length());
        }
        StringBuffer result = new StringBuffer(hexString);
        while (result.length() < len) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    private static String toHexString(int value) {
        return NativeMessage.toHexString(value, 8);
    }

    private static String toHexString(byte value) {
        return NativeMessage.toHexString(value, 2);
    }

    private static String toBinaryString(int value, int len) {
        String hexString = Integer.toBinaryString(value);
        if (hexString.length() > len) {
            hexString = hexString.substring(hexString.length() - len, hexString.length());
        }
        StringBuffer result = new StringBuffer(hexString);
        while (result.length() < len) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    private static String toBinaryString(int value) {
        return NativeMessage.toBinaryString(value, 32);
    }

    private static String toBinaryString(byte value) {
        return NativeMessage.toBinaryString(value, 8);
    }
}

