/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

public class Index {
    private int index;

    public Index(boolean isSoft, boolean isTxD, byte device, byte channel, short subIndex) {
        this.index |= isSoft ? 0x2000000 : 0;
        this.index |= isTxD ? 0x1000000 : 0;
        this.index |= device << 20 & 0xF00000;
        this.index |= channel << 16 & 0xF0000;
        this.index |= subIndex & 0xFFFF;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSoft() {
        return (this.index & 0x2000000) == 0x2000000;
    }

    public boolean isTxD() {
        return (this.index & 0x1000000) == 0x1000000;
    }

    public byte getDevice() {
        return (byte)(this.index >> 20 & 0xF);
    }

    public byte getChannel() {
        return (byte)(this.index >> 16 & 0xF);
    }

    public short getSubIndex() {
        return (short)(this.index & 0xFFFF);
    }

    public String toString() {
        return String.valueOf(this.isSoft() ? "Software Filter, " : "Hardware Filter, ") + (this.isTxD() ? "TxD, " : "RxD, ") + "Device " + this.getDevice() + ", Channel " + this.getChannel() + ", Sub Index " + this.getSubIndex();
    }
}

