/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.tinycan;

import com.sun.jna.Pointer;
import de.hardwarespielerei.can.tinycan.Bitrate;
import de.hardwarespielerei.can.tinycan.Channel;
import de.hardwarespielerei.can.tinycan.TinyCANException;
import java.util.Arrays;

public class Adapter {
    protected final int SIZE = 363;
    private int canIdx;
    private int hwId;
    private String deviceName;
    private String serialNumber;
    private String description;

    protected Adapter(Pointer p, int index) {
        byte[] data = p.getByteArray((long)(index * 363), 363);
        int offset = 0;
        this.canIdx = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        this.hwId = data[offset++] << 24 | data[offset++] << 16 | data[offset++] << 8 | data[offset++];
        byte[] dataString = Arrays.copyOfRange(data, offset, offset += 255);
        this.deviceName = new String(dataString).trim();
        dataString = Arrays.copyOfRange(data, offset, offset += 16);
        this.serialNumber = new String(dataString).trim();
        dataString = Arrays.copyOfRange(data, offset, offset += 64);
        this.description = new String(dataString).trim();
    }

    public int getCanIndex() {
        return this.canIdx;
    }

    public int getHardwareID() {
        return this.hwId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasModuleFeatures() {
        return this.getHardwareID() > 0;
    }

    public Channel openChannel(Bitrate bitrate) throws TinyCANException {
        return new Channel(this, bitrate);
    }

    public String toString() {
        return String.valueOf(this.getDescription()) + " # " + this.getSerialNumber();
    }
}

