/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb.test;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import de.hardwarespielerei.can.canusb.Library;
import java.io.IOException;

public class NativeTest {
    public static void main(String[] args) throws IOException {
        System.out.println("################################");
        System.out.println("# CANUSB Native Test           #");
        System.out.println("# (C) 2014 by Gabriel Schmidt  #");
        System.out.println("#  @see hardwarespielerei.de   #");
        System.out.println("################################");
        System.out.println();
        System.out.println("CANUSB     V0.3.1003");
        System.out.println("JNA        V4.1.0");
        System.out.println("JNA NATIVE V4.0.0");
        System.out.println();
        if (Platform.isWindows()) {
            Library.load();
            try {
                System.out.println("List of known adapters:");
                byte[] buffer = new byte[32];
                int numberOfCANUSB = Library.call().canusb_getFirstAdapter(buffer, buffer.length);
                String adapterID = Native.toString((byte[])buffer);
                int i = 0;
                while (i < numberOfCANUSB) {
                    NativeLong handle = Library.call().canusb_Open(adapterID, "1000", 0, -1, 1);
                    if (handle.longValue() <= 0L) {
                        throw new IOException("Error while opening CANUSB channel!");
                    }
                    try {
                        int status = Library.call().canusb_Status(handle);
                        byte[] info = Native.toByteArray((String)"VHhFf - Nxxxx - n.n.n - CCCCCCCCCC");
                        int rc = Library.call().canusb_VersionInfo(handle, info);
                        if (rc <= 0) {
                            throw new IOException("Error while reading VersionInfo from CANUSB!");
                        }
                        System.out.println(String.valueOf(i) + ". CANUSB-Adapter\tID=" + adapterID + "\tVersionInfo=" + Native.toString((byte[])info) + "\tStatus=" + status);
                    }
                    finally {
                        int rc = Library.call().canusb_Close(handle);
                        if (rc <= 0) {
                            throw new IOException("Error while closing CANUSB channel!");
                        }
                    }
                    int rc = Library.call().canusb_getNextAdapter(buffer, buffer.length);
                    if (rc <= 0) {
                        throw new IOException("Error while listing CANUSB adapters!");
                    }
                    adapterID = Native.toString((byte[])buffer);
                    ++i;
                }
                System.out.println("End of list.");
            }
            finally {
                Library.unload();
            }
        }
        System.out.println("CANUSB is not supported on this platform!");
    }
}

