/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb.test;

import com.sun.jna.Platform;
import de.hardwarespielerei.can.canusb.AcceptanceCode;
import de.hardwarespielerei.can.canusb.AcceptanceMask;
import de.hardwarespielerei.can.canusb.Adapter;
import de.hardwarespielerei.can.canusb.AdapterIterator;
import de.hardwarespielerei.can.canusb.Bitrate;
import de.hardwarespielerei.can.canusb.CANUSBException;
import de.hardwarespielerei.can.canusb.Channel;
import de.hardwarespielerei.can.canusb.Flag;
import de.hardwarespielerei.can.canusb.Library;
import de.hardwarespielerei.can.canusb.Status;

public class LibraryTest {
    public static void main(String[] args) throws CANUSBException {
        System.out.println("###############################");
        System.out.println("# CANUSB Library Test         #");
        System.out.println("# (C) 2014 by Gabriel Schmidt #");
        System.out.println("#  @see hardwarespielerei.de  #");
        System.out.println("###############################");
        System.out.println();
        System.out.println("CANUSB     V0.3.1003");
        System.out.println("JNA        V4.1.0");
        System.out.println("JNA NATIVE V4.0.0");
        System.out.println();
        if (Platform.isWindows()) {
            Library.load();
            try {
                System.out.println("List of known adapters:");
                AdapterIterator adapters = new AdapterIterator(Bitrate.Bitrate1Mbps);
                while (adapters.hasNext()) {
                    Adapter adapter = adapters.next();
                    Flag[] flags = new Flag[]{Flag.Timestamp};
                    try (Channel channel = adapter.openChannel(Bitrate.Bitrate1Mbps, AcceptanceCode.AcceptAll, AcceptanceMask.AcceptAll, flags);){
                        Status status = channel.getStatus();
                        String versionInfo = channel.getVersionInfo();
                        System.out.println("CANUSB # " + adapter.getSerialNumber() + "\tVersionInfo=" + versionInfo + "\tStatus=" + status);
                    }
                }
                System.out.println("End of list.");
            }
            finally {
                Library.unload();
            }
        } else {
            System.out.println("CANUSB is not supported on this platform!");
        }
    }
}

