/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb;

public class Status {
    private int status;

    protected Status(int status) {
        this.status = status;
    }

    public boolean isOK() {
        return this.status == 0;
    }

    public boolean isReceiveFifoFull() {
        return (this.status & 1) == 1;
    }

    public boolean isTransmitFifoFull() {
        return (this.status & 2) == 2;
    }

    public boolean isErrorWarning() {
        return (this.status & 4) == 4;
    }

    public boolean isDataOverrun() {
        return (this.status & 8) == 8;
    }

    public boolean isErrorPassive() {
        return (this.status & 0x20) == 32;
    }

    public boolean isArbitrationLost() {
        return (this.status & 0x40) == 64;
    }

    public boolean isBusError() {
        return (this.status & 0x80) == 128;
    }

    public String toString() {
        return String.valueOf(this.isOK() ? "OK, " : "") + (this.isReceiveFifoFull() ? "CANSTATUS_RECEIVE_FIFO_FULL, " : "") + (this.isTransmitFifoFull() ? "CANSTATUS_TRANSMIT_FIFO_FULL, " : "") + (this.isErrorWarning() ? "CANSTATUS_ERROR_WARNING, " : "") + (this.isDataOverrun() ? "CANSTATUS_DATA_OVERRUN, " : "") + (this.isErrorPassive() ? "CANSTATUS_ERROR_PASSIVE, " : "") + (this.isArbitrationLost() ? "CANSTATUS_ARBITRATION_LOST, " : "") + (this.isBusError() ? "CANSTATUS_BUS_ERROR, " : "") + ((this.status & 0xFFFFFF10) == 0 ? "" : "unknown error(s), ") + "0x" + Integer.toHexString(this.status);
    }
}

