/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb;

import de.hardwarespielerei.can.canusb.CANMessage;
import de.hardwarespielerei.can.canusb.jna.NativeAccess;
import java.util.Date;

public class NativeMessage
implements CANMessage {
    private NativeAccess.CANMsg msg;

    public NativeMessage(int id, int timestamp, boolean extendedID, boolean remoteFrame, byte reserver, byte length, byte[] data) {
        if ((reserver & 0xC0) != 0) {
            throw new IllegalArgumentException("Reserver has more then 6 bits!");
        }
        if (data != null && data.length > 8) {
            throw new IllegalArgumentException("Data is more than 8 bytes long!");
        }
        this.msg = new NativeAccess.CANMsg();
        this.msg.id = id;
        this.msg.timestamp = timestamp;
        this.msg.flags = (byte)(reserver | (extendedID ? 128 : 0) | (remoteFrame ? 64 : 0));
        this.msg.length = length;
        this.msg.data = data;
    }

    protected NativeMessage(NativeAccess.CANMsg msg) {
        this.msg = msg;
    }

    protected NativeAccess.CANMsg getNativeMessage() {
        return this.msg;
    }

    @Override
    public int getId() {
        return this.msg.id;
    }

    @Override
    public int getTimestamp() {
        return this.msg.timestamp;
    }

    @Override
    public boolean isExtendedID() {
        return 128 == (this.msg.flags & 0x80);
    }

    @Override
    public boolean isRemoteFrame() {
        return 64 == (this.msg.flags & 0x40);
    }

    @Override
    public byte getReserver() {
        return (byte)(this.msg.flags & 0x3F);
    }

    @Override
    public byte getLength() {
        return this.msg.length;
    }

    @Override
    public byte[] getData() {
        return this.msg.data;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ID:          0x").append(NativeMessage.toHexString(this.getId())).append("\t").append(NativeMessage.toBinaryString(this.getId())).append("\n");
        result.append("Timestamp:   0x").append(NativeMessage.toHexString(this.getTimestamp())).append("\t").append(new Date(this.getTimestamp())).append("\n");
        result.append("ExtendedID:  " + Boolean.toString(this.isExtendedID())).append("\n");
        result.append("RemoteFrame: ").append(Boolean.toString(this.isRemoteFrame())).append("\n");
        result.append("Reserver:    0x").append(NativeMessage.toHexString(this.getReserver())).append("\n");
        result.append("Length:      ").append(this.getLength()).append("\t0x").append(NativeMessage.toHexString(this.getLength())).append("\n");
        String dataPrefix = "Data:\t";
        byte[] byArray = this.getData();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte data = byArray[n2];
            result.append(dataPrefix).append(data).append("\t0x").append(NativeMessage.toHexString(data)).append("\t").append(NativeMessage.toBinaryString(data)).append("\n");
            dataPrefix = "\t";
            ++n2;
        }
        return result.toString();
    }

    private static String toHexString(int value, int len) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() > len) {
            hexString = hexString.substring(hexString.length() - len, hexString.length());
        }
        StringBuffer result = new StringBuffer(hexString);
        while (result.length() < len) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    private static String toHexString(int value) {
        return NativeMessage.toHexString(value, 8);
    }

    private static String toHexString(byte value) {
        return NativeMessage.toHexString(value, 2);
    }

    private static String toBinaryString(int value, int len) {
        String hexString = Integer.toBinaryString(value);
        if (hexString.length() > len) {
            hexString = hexString.substring(hexString.length() - len, hexString.length());
        }
        StringBuffer result = new StringBuffer(hexString);
        while (result.length() < len) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    private static String toBinaryString(int value) {
        return NativeMessage.toBinaryString(value, 32);
    }

    private static String toBinaryString(byte value) {
        return NativeMessage.toBinaryString(value, 8);
    }
}

