/*
 * Decompiled with CFR 0.152.
 */
package de.hardwarespielerei.can.canusb;

import de.hardwarespielerei.can.canusb.CommandSubsystemException;
import de.hardwarespielerei.can.canusb.InvalidHardwareException;
import de.hardwarespielerei.can.canusb.InvalidParamException;
import de.hardwarespielerei.can.canusb.MemoryErrorException;
import de.hardwarespielerei.can.canusb.NoDeviceException;
import de.hardwarespielerei.can.canusb.NoMessageException;
import de.hardwarespielerei.can.canusb.NotOpenException;
import de.hardwarespielerei.can.canusb.OpenSubsystemException;
import de.hardwarespielerei.can.canusb.TimeoutException;
import de.hardwarespielerei.can.canusb.TransmitFifoFullException;

public class CANUSBException
extends Exception {
    private static final long serialVersionUID = 8335621053024358913L;

    protected CANUSBException(int returnCode, String message) {
        super(String.valueOf(message) + " RC = " + returnCode);
    }

    protected static void throwOnErrorCode(int rc, String message) throws CANUSBException {
        switch (rc) {
            case 1: {
                break;
            }
            case -1: {
                throw new CANUSBException(rc, message);
            }
            case -2: {
                throw new OpenSubsystemException(rc, message);
            }
            case -3: {
                throw new CommandSubsystemException(rc, message);
            }
            case -4: {
                throw new NotOpenException(rc, message);
            }
            case -5: {
                throw new TransmitFifoFullException(rc, message);
            }
            case -6: {
                throw new InvalidParamException(rc, message);
            }
            case -7: {
                throw new NoMessageException(rc, message);
            }
            case -8: {
                throw new MemoryErrorException(rc, message);
            }
            case -9: {
                throw new NoDeviceException(rc, message);
            }
            case -10: {
                throw new TimeoutException(rc, message);
            }
            case -11: {
                throw new InvalidHardwareException(rc, message);
            }
            default: {
                throw new CANUSBException(rc, message);
            }
        }
    }
}

